package zfp.config;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import zfp.activity.Ctr;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceHolder.Callback;
import android.view.SurfaceView;

@SuppressLint("NewApi")
public class PaintVedio extends SurfaceView implements Callback, Runnable {
	
	private static final String TAG = "PaintVedio";
	//ĻС
	private static int screenWidth;//Ļߴ籣
	private static int screenHeight;
	//̱߳
	public static boolean runFlag = false;//Ϊ.ʱûжԴ˱ʵ
	private static SurfaceHolder holder;//ֵʵʵsurfaceView holderַ.ֻǱڵ
	private static HttpURLConnection conn;//URL HTTPַ,ֻΪ.viewʱر
	private static Thread thread;//Դͼ̱߳,surfaceView״̬ıʱ ûر

	public PaintVedio(Context context, AttributeSet attrs) {
		super(context, attrs);//й,
		screenValue();//Ļߴ縳ֵ
		holder = this.getHolder();
		holder.addCallback(this);//ԴĻص
	}

	// ========================================
	/**
	 * Ļֵ
	 */
	private void screenValue() {
		DisplayMetrics dm = new DisplayMetrics();
		dm = getResources().getDisplayMetrics();
		screenWidth = dm.widthPixels;
		screenHeight = dm.heightPixels;
		Log.i(TAG, "screenWidth ="+screenWidth);
		Log.i(TAG, "screenHeight ="+screenHeight);
	}
	
	
	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		runFlag = true;
		thread = new Thread(this);
		thread.start();
	}

	
	@Override
	public void surfaceChanged(SurfaceHolder holder, int format, int width,
			int height) {
//		change¼лʱ.гʼһ
//		runFlag = true;
//		thread = new Thread(this);
//		thread.start();
	}

	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {
		if( !Ctr.isLive ){
			runFlag = false;
			Log.i(TAG, "surfaceDestroyed");
			if(holder != null && conn != null){
				conn.disconnect();
				thread.interrupt();
			}
		}
	}

	@Override
	public void run() {
		Canvas c = null;
		Bitmap bmp;
		InputStream is;
		URL videoURL = null;
//		Paint p = new Paint(); // ,ͼԲҪ
		String imageURL = "http://192.168.8.1:8083/?action=snapshot";//Ƶַ,עýaction.
		try {
			videoURL = new URL(imageURL);;	
		} catch (Exception e) {
		}
		//ͼ
		BitmapFactory.Options o = new BitmapFactory.Options();// ԭͼֵ
		o.inPreferredConfig = Bitmap.Config.ARGB_8888;// 
		while (runFlag) {
			//c = null;
			try {
				synchronized (holder) {
					c = holder.lockCanvas();// һͿͨ䷵صĻCanvas滭ͼȲˡ
					// ===========================================================
				//	Ӻ,ֻһ,ҪӲ
				 	conn = (HttpURLConnection)videoURL.openConnection();//˷new HttpURLConnectionconnect()
//					conn.connect();//getInputStreamԶô˷.˷һnew HttpURLConnection֮.(newʱûз)
					is = conn.getInputStream(); //ȡ
					bmp = BitmapFactory.decodeStream(is, null, o);
					bmp = Bitmap.createScaledBitmap(bmp, screenWidth,
							screenHeight, true);// ͼƬĻߴ
					c.drawBitmap(bmp, 0, 0, null);
					
					Thread.sleep(10);// ʱ,Ž.Լֱܷ42ͼ.					
					
				}
			} catch (Exception e) {
//				System.out.println(e.getMessage());
			}finally{
				//if(holder != null && conn != null)
				if(c != null)
				{
					holder.unlockCanvasAndPost(c);// ͼύ
					conn.disconnect();
				}
			}
		}

	}
}
